/*
 * Decompiled with CFR 0.152.
 */
package net.regions_unexplored.item;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.regions_unexplored.entity.custom.RuBoat;
import net.regions_unexplored.entity.custom.RuChestBoat;
import net.regions_unexplored.item.RuBoatItemBehaviour;

public class RuBoatItem
extends Item {
    private static final Predicate<Entity> ENTITY_PREDICATE = EntitySelector.f_20408_.and(Entity::m_6087_);
    private final RuBoat.ModelType model;
    private final boolean chest;

    public RuBoatItem(boolean chest, RuBoat.ModelType model, Item.Properties properties) {
        super(properties);
        this.model = model;
        this.chest = chest;
        DispenserBlock.m_52672_((ItemLike)this, (DispenseItemBehavior)new RuBoatItemBehaviour(chest, model));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        BlockHitResult hitResult = RuBoatItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        Vec3 vec3 = player.m_20252_(1.0f);
        List list = level.m_6249_((Entity)player, player.m_20191_().m_82369_(vec3.m_82490_(5.0)).m_82400_(1.0), ENTITY_PREDICATE);
        if (!list.isEmpty()) {
            Vec3 vec31 = player.m_146892_();
            for (Entity entity : list) {
                AABB aabb = entity.m_20191_().m_82400_((double)entity.m_6143_());
                if (!aabb.m_82390_(vec31)) continue;
                return InteractionResultHolder.m_19098_((Object)itemStack);
            }
        }
        if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
            Object boat;
            if (this.chest) {
                boat = new RuChestBoat(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
                ((RuChestBoat)((Object)boat)).setModel(this.model);
            } else {
                boat = new RuBoat(level, hitResult.m_82450_().f_82479_, hitResult.m_82450_().f_82480_, hitResult.m_82450_().f_82481_);
                ((RuBoat)((Object)boat)).setModel(this.model);
            }
            boat.m_146922_(player.m_146908_());
            if (!level.m_45756_((Entity)boat, boat.m_20191_())) {
                return InteractionResultHolder.m_19100_((Object)itemStack);
            }
            if (!level.f_46443_) {
                level.m_7967_((Entity)boat);
                level.m_220400_((Entity)player, GameEvent.f_157810_, hitResult.m_82450_());
                if (!player.m_150110_().f_35937_) {
                    itemStack.m_41774_(1);
                }
            }
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            return InteractionResultHolder.m_19092_((Object)itemStack, (boolean)level.m_5776_());
        }
        return InteractionResultHolder.m_19098_((Object)itemStack);
    }
}

